(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     53029,       1071]*)
(*NotebookOutlinePosition[     53745,       1096]*)
(*  CellTagsIndexPosition[     53701,       1092]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
    \(f[x_] = x - 0.6  Sin[x]\)], "Input"],

Cell[BoxData[
    \(x - 0.6`\ Sin[x]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(A = 
      Plot[f[x], {x, 0, 10}, \ 
        AspectRatio \[Rule] Automatic\[IndentingNewLine], 
        AxesStyle \[Rule] {Thickness[0.003]}, 
        PlotStyle \[Rule] {Thickness[0.0035]}, AxesOrigin \[Rule] {0, 0}, 
        Ticks \[Rule] None]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.03264 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0952381 0.0245867 0.0952381 [
[ -0.0015 -0.0015 0 0 ]
[ 1.0015 1.03414 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.003 w
[ ] 0 setdash
0 .02459 m
1 .02459 L
s
.02381 0 m
.02381 1.03264 L
s
0 0 m
1 0 L
1 1.03264 L
0 1.03264 L
closepath
clip
newpath
.0035 w
.02381 .02459 m
.06244 .04067 L
.10458 .0625 L
.14415 .09046 L
.18221 .12609 L
.22272 .17384 L
.26171 .22819 L
.30316 .29211 L
.34309 .35582 L
.3815 .41521 L
.42237 .47252 L
.46172 .51926 L
.49955 .5552 L
.53984 .5841 L
.57861 .60464 L
.61984 .62204 L
.65954 .63849 L
.69774 .6578 L
.73838 .6855 L
.77751 .72125 L
.81909 .76963 L
.85916 .82519 L
.89771 .88442 L
.93871 .94982 L
.97619 1.00805 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{312.938, 323.125},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004h0001@a000`40O003h00Oogoo>Goo0007Ool0
0`00Oomoo`3oOol_Ool000Moo`03001oogoo0?moobmoo`001goo00<007ooOol0ogoo;goo0007Ool0
0`00Oomoo`3oOol_Ool000Moo`03001oogoo0?moobmoo`001goo00<007ooOol0ogoo;goo0007Ool0
0`00Oomoo`3oOol_Ool000Moo`03001oogoo0?moobmoo`00o`00>@000007Ool01000Ool00000ogoo
;Woo0007Ool01000Oomoogoo0P00ogoo;7oo0007Ool00`00Oomoo`03Ool3003oOolYOol000Moo`03
001oogoo00Ioo`800?moobMoo`001goo00<007ooOol027oo0`00ogoo97oo0007Ool00`00Oomoo`0;
Ool2003oOolROol000Moo`03001oogoo00eoo`800?moob1oo`001goo00<007ooOol03goo0P00ogoo
7Woo0007Ool00`00Oomoo`0AOol2003oOolLOol000Moo`03001oogoo01=oo`800?mooaYoo`001goo
00<007ooOol05Goo0P00ogoo67oo0007Ool00`00Oomoo`0GOol2003oOolFOol000Moo`03001oogoo
01Uoo`03001oogoo0?mooa=oo`001goo00<007ooOol06Woo0P00ogoo4goo0007Ool00`00Oomoo`0L
Ool00`00Oomoo`3oOol@Ool000Moo`03001oogoo01eoo`03001oogoo0?moo`moo`001goo00<007oo
Ool07Woo0P00ogoo3goo0007Ool00`00Oomoo`0POol00`00Oomoo`3oOol<Ool000Moo`03001oogoo
025oo`800?moo`aoo`001goo00<007ooOol08goo00<007ooOol0ogoo2Goo0007Ool00`00Oomoo`0T
Ool00`00Oomoo`3oOol8Ool000Moo`03001oogoo02Eoo`03001oogoo0?moo`Moo`001goo00<007oo
Ool09Woo00<007ooOol0ogoo1Woo0007Ool00`00Oomoo`0WOol00`00Oomoo`3oOol5Ool000Moo`03
001oogoo02Qoo`800?moo`Eoo`001goo00<007ooOol0:Woo00<007ooOol0ogoo0Woo0007Ool00`00
Oomoo`0[Ool00`00Oomoo`3oOol1Ool000Moo`03001oogoo02aoo`03001oogoo0?moo`001goo00<0
07ooOol0;Goo00<007ooOol0oWoo0007Ool00`00Oomoo`0^Ool00`00Oomoo`3mOol000Moo`03001o
ogoo02moo`03001oogoo0?aoo`001goo00<007ooOol0<7oo00<007ooOol0ngoo0007Ool00`00Oomo
o`0aOol00`00Oomoo`3jOol000Moo`03001oogoo035oo`03001oogoo0?Yoo`001goo00<007ooOol0
<Woo00<007ooOol0nGoo0007Ool00`00Oomoo`0cOol00`00Oomoo`3hOol000Moo`03001oogoo03Ao
o`03001oogoo0?Moo`001goo00<007ooOol0=Goo00<007ooOol0mWoo0007Ool00`00Oomoo`0eOol0
0`00Oomoo`3fOol000Moo`03001oogoo03Ioo`03001oogoo0?Eoo`001goo00<007ooOol0=goo00<0
07ooOol0m7oo0007Ool00`00Oomoo`0hOol00`00Oomoo`3cOol000Moo`03001oogoo03Uoo`03001o
ogoo0?9oo`001goo00<007ooOol0>Goo00<007ooOol0lWoo0007Ool00`00Oomoo`0jOol00`00Oomo
o`3aOol000Moo`03001oogoo03]oo`03001oogoo0?1oo`001goo00<007ooOol0?7oo00<007ooOol0
kgoo0007Ool00`00Oomoo`0lOol00`00Oomoo`3_Ool000Moo`03001oogoo03eoo`03001oogoo0>io
o`001goo00<007ooOol0?Woo00<007ooOol0kGoo0007Ool00`00Oomoo`0oOol00`00Oomoo`3/Ool0
00Moo`03001oogoo03moo`03001oogoo0>aoo`001goo00<007ooOol0@7oo00<007ooOol0jgoo0007
Ool00`00Oomoo`11Ool00`00Oomoo`3ZOol000Moo`03001oogoo045oo`03001oogoo0>Yoo`001goo
00<007ooOol0@Woo00<007ooOol0jGoo0007Ool00`00Oomoo`13Ool00`00Oomoo`3XOol000Moo`03
001oogoo04=oo`03001oogoo0>Qoo`001goo00<007ooOol0A7oo00<007ooOol0igoo0007Ool00`00
Oomoo`15Ool00`00Oomoo`3VOol000Moo`03001oogoo04Ioo`03001oogoo0>Eoo`001goo00<007oo
Ool0AWoo00<007ooOol0iGoo0007Ool00`00Oomoo`17Ool00`00Oomoo`3TOol000Moo`03001oogoo
04Qoo`03001oogoo0>=oo`001goo00<007ooOol0B7oo00<007ooOol0hgoo0007Ool00`00Oomoo`19
Ool00`00Oomoo`3ROol000Moo`03001oogoo04Yoo`03001oogoo0>5oo`001goo00<007ooOol0BWoo
00<007ooOol0hGoo0007Ool00`00Oomoo`1;Ool00`00Oomoo`3POol000Moo`03001oogoo04aoo`03
001oogoo0=moo`001goo00<007ooOol0C7oo00<007ooOol0ggoo0007Ool00`00Oomoo`1=Ool00`00
Oomoo`3NOol000Moo`03001oogoo04eoo`03001oogoo0=ioo`001goo00<007ooOol0CWoo00<007oo
Ool0gGoo0007Ool00`00Oomoo`1?Ool00`00Oomoo`3LOol000Moo`03001oogoo04moo`03001oogoo
0=aoo`001goo00<007ooOol0D7oo00<007ooOol0fgoo0007Ool00`00Oomoo`1AOol00`00Oomoo`3J
Ool000Moo`03001oogoo055oo`03001oogoo0=Yoo`001goo00<007ooOol0DWoo00<007ooOol0fGoo
0007Ool00`00Oomoo`1COol00`00Oomoo`3HOol000Moo`03001oogoo05=oo`03001oogoo0=Qoo`00
1goo00<007ooOol0E7oo00<007ooOol0egoo0007Ool00`00Oomoo`1EOol00`00Oomoo`3FOol000Mo
o`03001oogoo05Eoo`03001oogoo0=Ioo`001goo00<007ooOol0EWoo00<007ooOol0eGoo0007Ool0
0`00Oomoo`1GOol00`00Oomoo`3DOol000Moo`03001oogoo05Moo`03001oogoo0=Aoo`001goo00<0
07ooOol0F7oo00<007ooOol0dgoo0007Ool00`00Oomoo`1IOol00`00Oomoo`3BOol000Moo`03001o
ogoo05Uoo`03001oogoo0=9oo`001goo00<007ooOol0FWoo00<007ooOol0dGoo0007Ool00`00Oomo
o`1JOol00`00Oomoo`3AOol000Moo`03001oogoo05]oo`03001oogoo0=1oo`001goo00<007ooOol0
G7oo00<007ooOol0cgoo0007Ool00`00Oomoo`1LOol00`00Oomoo`3?Ool000Moo`03001oogoo05eo
o`03001oogoo0<ioo`001goo00<007ooOol0GWoo00<007ooOol0cGoo0007Ool00`00Oomoo`1NOol0
0`00Oomoo`3=Ool000Moo`03001oogoo05moo`03001oogoo0<aoo`001goo00<007ooOol0H7oo00<0
07ooOol0bgoo0007Ool00`00Oomoo`1POol00`00Oomoo`3;Ool000Moo`03001oogoo065oo`03001o
ogoo0<Yoo`001goo00<007ooOol0HWoo00<007ooOol0bGoo0007Ool00`00Oomoo`1ROol00`00Oomo
o`39Ool000Moo`03001oogoo06=oo`03001oogoo0<Qoo`001goo00<007ooOol0I7oo00<007ooOol0
agoo0007Ool00`00Oomoo`1TOol00`00Oomoo`37Ool000Moo`03001oogoo06Eoo`03001oogoo0<Io
o`001goo00<007ooOol0IWoo00<007ooOol0aGoo0007Ool00`00Oomoo`1VOol00`00Oomoo`35Ool0
00Moo`03001oogoo06Moo`03001oogoo0<Aoo`001goo00<007ooOol0J7oo00<007ooOol0`goo0007
Ool00`00Oomoo`1XOol00`00Oomoo`33Ool000Moo`03001oogoo06Uoo`03001oogoo0<9oo`001goo
00<007ooOol0JWoo00<007ooOol0`Goo0007Ool00`00Oomoo`1ZOol00`00Oomoo`31Ool000Moo`03
001oogoo06]oo`03001oogoo0<1oo`001goo00<007ooOol0K7oo00<007ooOol0_goo0007Ool00`00
Oomoo`1/Ool00`00Oomoo`2oOol000Moo`03001oogoo06eoo`03001oogoo0;ioo`001goo00<007oo
Ool0KWoo00<007ooOol0_Goo0007Ool00`00Oomoo`1^Ool00`00Oomoo`2mOol000Moo`03001oogoo
06moo`03001oogoo0;aoo`001goo00<007ooOol0L7oo00<007ooOol0^goo0007Ool00`00Oomoo`1`
Ool00`00Oomoo`2kOol000Moo`03001oogoo075oo`03001oogoo0;Yoo`001goo00<007ooOol0LWoo
00<007ooOol0^Goo0007Ool00`00Oomoo`1bOol00`00Oomoo`2iOol000Moo`03001oogoo07=oo`03
001oogoo0;Qoo`001goo00<007ooOol0M7oo00<007ooOol0]goo0007Ool00`00Oomoo`1dOol00`00
Oomoo`2gOol000Moo`03001oogoo07Eoo`03001oogoo0;Ioo`001goo00<007ooOol0MWoo00<007oo
Ool0]Goo0007Ool00`00Oomoo`1fOol00`00Oomoo`2eOol000Moo`03001oogoo07Moo`03001oogoo
0;Aoo`001goo00<007ooOol0N7oo00<007ooOol0/goo0007Ool00`00Oomoo`1hOol00`00Oomoo`2c
Ool000Moo`03001oogoo07Uoo`03001oogoo0;9oo`001goo00<007ooOol0NWoo00<007ooOol0/Goo
0007Ool00`00Oomoo`1kOol00`00Oomoo`2`Ool000Moo`03001oogoo07aoo`03001oogoo0:moo`00
1goo00<007ooOol0OGoo00<007ooOol0[Woo0007Ool00`00Oomoo`1nOol00`00Oomoo`2]Ool000Mo
o`03001oogoo07moo`03001oogoo0:aoo`001goo00<007ooOol0Ogoo00<007ooOol0[7oo0007Ool0
0`00Oomoo`20Ool00`00Oomoo`2[Ool000Moo`03001oogoo085oo`03001oogoo0:Yoo`001goo00<0
07ooOol0PWoo00<007ooOol0ZGoo0007Ool00`00Oomoo`23Ool00`00Oomoo`2XOol000Moo`03001o
ogoo08Aoo`03001oogoo0:Moo`001goo00<007ooOol0QGoo00<007ooOol0YWoo0007Ool00`00Oomo
o`26Ool00`00Oomoo`2UOol000Moo`03001oogoo08Moo`03001oogoo0:Aoo`001goo00<007ooOol0
R7oo00<007ooOol0Xgoo0007Ool00`00Oomoo`29Ool00`00Oomoo`2ROol000Moo`03001oogoo08Yo
o`03001oogoo0:5oo`001goo00<007ooOol0Rgoo00<007ooOol0X7oo0007Ool00`00Oomoo`2;Ool0
0`00Oomoo`2POol000Moo`03001oogoo08aoo`03001oogoo09moo`001goo00<007ooOol0SGoo00<0
07ooOol0WWoo0007Ool00`00Oomoo`2>Ool00`00Oomoo`2MOol000Moo`03001oogoo08moo`03001o
ogoo09aoo`001goo00<007ooOol0T7oo00<007ooOol0Vgoo0007Ool00`00Oomoo`2AOol00`00Oomo
o`2JOol000Moo`03001oogoo099oo`8009Yoo`001goo00<007ooOol0U7oo00<007ooOol0Ugoo0007
Ool00`00Oomoo`2EOol2002GOol000Moo`03001oogoo09Moo`03001oogoo09Aoo`001goo00<007oo
Ool0V7oo00<007ooOol0Tgoo0007Ool00`00Oomoo`2IOol2002COol000Moo`03001oogoo09]oo`03
001oogoo091oo`001goo00<007ooOol0W7oo0P00T7oo0007Ool00`00Oomoo`2NOol2002>Ool000Mo
o`03001oogoo0:1oo`8008aoo`001goo00<007ooOol0XWoo0P00RWoo0007Ool00`00Oomoo`2TOol2
0028Ool000Moo`03001oogoo0:Ioo`8008Ioo`001goo00<007ooOol0Z7oo0P00Q7oo0007Ool00`00
Oomoo`2ZOol20022Ool000Moo`03001oogoo0:aoo`80081oo`001goo00<007ooOol0[Woo0`00OGoo
0007Ool00`00Oomoo`2aOol3001jOol000Moo`03001oogoo0;Aoo`8007Qoo`001goo00<007ooOol0
]Woo0`00MGoo0007Ool00`00Oomoo`2iOol2001cOol000Moo`03001oogoo0;]oo`80075oo`001goo
00<007ooOol0_Goo0`00KWoo0007Ool00`00Oomoo`30Ool2001/Ool000Moo`03001oogoo0<9oo`<0
06Uoo`001goo00<007ooOol0aGoo0P00Igoo0007Ool00`00Oomoo`37Ool2001UOol000Moo`03001o
ogoo0<Uoo`8006=oo`001goo00<007ooOol0bgoo0P00HGoo0007Ool00`00Oomoo`3=Ool2001OOol0
00Moo`03001oogoo0<moo`03001oogoo05aoo`001goo00<007ooOol0d7oo0P00G7oo0007Ool00`00
Oomoo`3BOol00`00Oomoo`1IOol000Moo`03001oogoo0==oo`8005Uoo`001goo00<007ooOol0eGoo
00<007ooOol0EWoo0007Ool00`00Oomoo`3FOol00`00Oomoo`1EOol000Moo`03001oogoo0=Moo`80
05Eoo`001goo00<007ooOol0fGoo00<007ooOol0DWoo0007Ool00`00Oomoo`3JOol2001BOol000Mo
o`03001oogoo0=aoo`03001oogoo04moo`001goo00<007ooOol0gGoo00<007ooOol0CWoo0007Ool0
0`00Oomoo`3NOol00`00Oomoo`1=Ool000Moo`03001oogoo0=moo`03001oogoo04aoo`001goo00<0
07ooOol0h7oo00<007ooOol0Bgoo0007Ool00`00Oomoo`3QOol2001;Ool000Moo`03001oogoo0>=o
o`03001oogoo04Qoo`001goo00<007ooOol0i7oo00<007ooOol0Agoo0007Ool00`00Oomoo`3UOol0
0`00Oomoo`16Ool000Moo`03001oogoo0>Ioo`03001oogoo04Eoo`001goo00<007ooOol0igoo00<0
07ooOol0A7oo0007Ool00`00Oomoo`3XOol00`00Oomoo`13Ool000Moo`03001oogoo0>Uoo`03001o
ogoo049oo`001goo00<007ooOol0jWoo00<007ooOol0@Goo0007Ool00`00Oomoo`3[Ool00`00Oomo
o`10Ool000Moo`03001oogoo0>]oo`03001oogoo041oo`001goo00<007ooOol0k7oo00<007ooOol0
?goo0007Ool00`00Oomoo`3]Ool00`00Oomoo`0nOol000Moo`03001oogoo0>ioo`03001oogoo03eo
o`001goo00<007ooOol0kgoo00<007ooOol0?7oo0007Ool00`00Oomoo`3`Ool00`00Oomoo`0kOol0
00Moo`03001oogoo0?5oo`03001oogoo03Yoo`001goo00<007ooOol0lWoo00<007ooOol0>Goo0007
Ool00`00Oomoo`3bOol00`00Oomoo`0iOol000Moo`03001oogoo0?=oo`03001oogoo03Qoo`001goo
00<007ooOol0m7oo00<007ooOol0=goo0007Ool00`00Oomoo`3eOol00`00Oomoo`0fOol000Moo`03
001oogoo0?Ioo`03001oogoo03Eoo`001goo00<007ooOol0mWoo00<007ooOol0=Goo0007Ool00`00
Oomoo`3gOol00`00Oomoo`0dOol000Moo`03001oogoo0?Qoo`03001oogoo03=oo`001goo00<007oo
Ool0nGoo00<007ooOol0<Woo0007Ool00`00Oomoo`3iOol00`00Oomoo`0bOol000Moo`03001oogoo
0?Yoo`03001oogoo035oo`001goo00<007ooOol0ngoo00<007ooOol0<7oo0007Ool00`00Oomoo`3k
Ool00`00Oomoo`0`Ool000Moo`03001oogoo0?aoo`03001oogoo02moo`001goo00<007ooOol0oGoo
00<007ooOol0;Woo0007Ool00`00Oomoo`3mOol00`00Oomoo`0^Ool000Moo`03001oogoo0?ioo`03
001oogoo02eoo`001goo00<007ooOol0ogoo00<007ooOol0;7oo0007Ool00`00Oomoo`3oOol1Ool0
0`00Oomoo`0[Ool000Moo`03001oogoo0?moo`5oo`03001oogoo02]oo`001goo00<007ooOol0ogoo
0Woo00<007ooOol0:Woo0007Ool00`00Oomoo`3oOol3Ool00`00Oomoo`0YOol000Moo`03001oogoo
0?moo`=oo`03001oogoo02Uoo`001goo00<007ooOol0ogoo17oo00<007ooOol0:7oo0007Ool00`00
Oomoo`3oOol5Ool00`00Oomoo`0WOol000Moo`03001oogoo0?moo`Eoo`03001oogoo02Moo`001goo
00<007ooOol0ogoo1Woo00<007ooOol09Woo0007Ool00`00Oomoo`3oOol6Ool00`00Oomoo`0VOol0
00Moo`03001oogoo0?moo`Moo`03001oogoo02Eoo`001goo00<007ooOol0ogoo27oo00<007ooOol0
97oo0007Ool00`00Oomoo`3oOol8Ool00`00Oomoo`0TOol000Moo`03001oogoo0?moo`Uoo`03001o
ogoo02=oo`001goo00<007ooOol0ogoo2Woo00<007ooOol08Woo0007Ool00`00Oomoo`3oOol:Ool0
0`00Oomoo`0ROol000Moo`03001oogoo0?moo`]oo`03001oogoo025oo`001goo00<007ooOol0ogoo
2goo00<007ooOol08Goo0007Ool00`00Oomoo`3oOol<Ool00`00Oomoo`0POol000Moo`03001oogoo
0?moo`eoo`03001oogoo01moo`001goo00<007ooOol0ogoo3Goo00<007ooOol07goo0007Ool00`00
Oomoo`3oOol>Ool00`00Oomoo`0NOol000Moo`03001oogoo0?moo`moo`03001oogoo01eoo`001goo
00<007ooOol0ogoo3goo00<007ooOol07Goo0007Ool00`00Oomoo`3oOol@Ool00`00Oomoo`0LOol0
00Moo`03001oogoo0?mooa5oo`03001oogoo01]oo`001goo00<007ooOol0ogoo4Goo00<007ooOol0
6goo0007Ool00`00Oomoo`3oOolBOol00`00Oomoo`0JOol000Moo`03001oogoo0?mooa=oo`03001o
ogoo01Uoo`001goo00<007ooOol0ogoo4goo00<007ooOol06Goo0007Ool00`00Oomoo`3oOolDOol0
0`00Oomoo`0HOol000Moo`03001oogoo0?mooaAoo`03001oogoo01Qoo`001goo00<007ooOol0ogoo
5Goo00<007ooOol05goo0007Ool00`00Oomoo`3oOolFOol00`00Oomoo`0FOol000Moo`03001oogoo
0?mooaIoo`03001oogoo01Ioo`001goo00<007ooOol0ogoo5goo00<007ooOol05Goo0007Ool00`00
Oomoo`3oOolHOol00`00Oomoo`0DOol000Moo`03001oogoo0?mooaQoo`03001oogoo01Aoo`001goo
00<007ooOol0ogoo6Goo00<007ooOol04goo0007Ool00`00Oomoo`3oOolJOol00`00Oomoo`0BOol0
00Moo`03001oogoo0?mooaYoo`03001oogoo019oo`001goo00<007ooOol0ogoo6goo00<007ooOol0
4Goo0007Ool00`00Oomoo`3oOolLOol00`00Oomoo`0@Ool000Moo`03001oogoo0?mooaaoo`03001o
ogoo011oo`001goo00<007ooOol0ogoo7Goo00<007ooOol03goo0007Ool00`00Oomoo`3oOolNOol0
0`00Oomoo`0>Ool000Moo`03001oogoo0?mooaioo`03001oogoo00ioo`001goo00<007ooOol0ogoo
7goo00<007ooOol03Goo0007Ool00`00Oomoo`3oOolPOol00`00Oomoo`0<Ool000Moo`03001oogoo
0?moob1oo`03001oogoo00aoo`001goo00<007ooOol0ogoo8Goo00<007ooOol02goo0007Ool00`00
Oomoo`3oOolROol00`00Oomoo`0:Ool000Moo`03001oogoo0?moob9oo`03001oogoo00Yoo`001goo
00<007ooOol0ogoo8goo00<007ooOol02Goo0007Ool00`00Oomoo`3oOolTOol00`00Oomoo`08Ool0
00Moo`03001oogoo0?moobAoo`03001oogoo00Qoo`001goo00<007ooOol0ogoo9Goo00<007ooOol0
1goo0007Ool00`00Oomoo`3oOolVOol00`00Oomoo`06Ool000Moo`03001oogoo0?moobIoo`03001o
ogoo00Ioo`001goo00<007ooOol0ogoo9goo00<007ooOol01Goo0007Ool00`00Oomoo`3oOol_Ool0
00Moo`03001oogoo0?moobmoo`001goo00<007ooOol0ogoo;goo0007Ool00`00Oomoo`3oOol_Ool0
00Moo`03001oogoo0?moobmoo`001goo00<007ooOol0ogoo;goo0007Ool00`00Oomoo`3oOol_Ool0
00Moo`03001oogoo0?moobmoo`00\
\>"],
  ImageRangeCache->{{{0, 311.938}, {322.125, 0}} -> {-0.265802, -0.274578, \
0.0337619, 0.0337619}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(B = {Line[{{2, 0}, {2, f[2]}, {0, f[2]}}], 
        Line[{{0, 0}, {10, 10 \( f'\)[0]}}], 
        Line[{{0, 0}, {2, f[2]}, {9, 4.5  f[2]}}], 
        Line[{{0, f[2] - 2 \( f'\)[2]}, {8, f[2] + \(f'\)[2] 6}}], 
        Line[{{4, 0}, {4, f[4]}, {0, f[4]}}], 
        Line[{{5, 0}, {5, f[5]}, {0, f[5]}}], Text[a1, {1.8, \(-0.5\)}], 
        Text[b1, {\(-1\), f[2]}], Text[e1, {3, \(-1.7\)}], 
        Text[c1, {4.8, \(-0.5\)}], Text[d1, {\(-0.9\), f[5]}], 
        Text[a2, {7, f[7] - 0.5}], Text[a6, {6, 3  f[2] - 0.4}], 
        Text[a4, {7, 7 \( f'\)[0] - 0.4}], 
        Text[a5, {1, f[2] + 5 \( f'\)[2] + 0.4}]}\)], "Input"],

Cell[BoxData[
    \({Line[{{2, 0}, {2, 1.454421543904591`}, {0, 1.454421543904591`}}], 
      Line[{{0, 0}, {10, 4.`}}], 
      Line[{{0, 0}, {2, 1.454421543904591`}, {9, 6.54489694757066`}}], 
      Line[{{0, \(-1.04495465995198`\)}, {8, 8.952550155474304`}}], 
      Line[{{4, 0}, {4, 4.454081497184757`}, {0, 4.454081497184757`}}], 
      Line[{{5, 0}, {5, 5.575354564797883`}, {0, 5.575354564797883`}}], 
      Text[a1, {1.8`, \(-0.5`\)}], Text[b1, {\(-1\), 1.454421543904591`}], 
      Text[e1, {3, \(-1.7`\)}], Text[c1, {4.8`, \(-0.5`\)}], 
      Text[d1, {\(-0.9`\), 5.575354564797883`}], 
      Text[a2, {7, 6.105808040768727`}], Text[a6, {6, 3.963264631713774`}], 
      Text[a4, {7, 2.4000000000000004`}], 
      Text[a5, {1, 8.10286205354602`}]}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[A, Graphics[B]]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.09331 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.11039 0.0865801 0.173217 0.0865801 [
[ -0.0015 -0.0015 0 0 ]
[ 1.0015 1.09481 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.003 w
[ ] 0 setdash
0 .17322 m
1 .17322 L
s
.11039 0 m
.11039 1.09331 L
s
0 0 m
1 0 L
1 1.09331 L
0 1.09331 L
closepath
clip
newpath
.0035 w
.11039 .17322 m
.14551 .18784 L
.18382 .20768 L
.21979 .2331 L
.25439 .26549 L
.29121 .3089 L
.32666 .35832 L
.36434 .41642 L
.40064 .47434 L
.43556 .52833 L
.47271 .58043 L
.50849 .62292 L
.54288 .65559 L
.57951 .68187 L
.61475 .70054 L
.65223 .71635 L
.68833 .73131 L
.72305 .74887 L
.76 .77405 L
.79557 .80655 L
.83338 .85053 L
.8698 .90104 L
.90485 .95488 L
.94212 1.01434 L
.97619 1.06728 L
s
.5 Mabswid
.28355 .17322 m
.28355 .29914 L
.11039 .29914 L
s
.11039 .17322 m
.97619 .51954 L
s
.11039 .17322 m
.28355 .29914 L
.88961 .73988 L
s
.11039 .08275 m
.80303 .94833 L
s
.45671 .17322 m
.45671 .55885 L
.11039 .55885 L
s
.54329 .17322 m
.54329 .65593 L
.11039 .65593 L
s
gsave
.26623 .12993 -69 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.875 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a1) show
1.000 setlinewidth
grestore
gsave
.02381 .29914 -69 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.875 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(b1) show
1.000 setlinewidth
grestore
gsave
.37013 .02603 -69 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.875 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(e1) show
1.000 setlinewidth
grestore
gsave
.52597 .12993 -69 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.875 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(c1) show
1.000 setlinewidth
grestore
gsave
.03247 .65593 -69 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.875 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(d1) show
1.000 setlinewidth
grestore
gsave
.71645 .70186 -69 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.875 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a2) show
1.000 setlinewidth
grestore
gsave
.62987 .51636 -69 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.875 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a6) show
1.000 setlinewidth
grestore
gsave
.71645 .38101 -69 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.875 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a4) show
1.000 setlinewidth
grestore
gsave
.19697 .87476 -69 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.875 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a5) show
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{369.188, 403.625},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005a0001Ta000`40O003h00OogooLWoo000YOol0
0`00Oomoo`3oOom6Ool002Uoo`03001oogoo0?moodIoo`00:Goo00<007ooOol0ogooAWoo000YOol0
0`00Oomoo`3oOom6Ool002Uoo`03001oogoo0?moodIoo`00:Goo00<007ooOol0ogooAWoo000YOol0
0`00Oomoo`3oOom6Ool002Uoo`03001oogoo0?moodIoo`00:Goo00<007ooOol0F7oo0`000Woo1@00
hgoo000YOol00`00Oomoo`1GOol00`00Oomoo`05Ool00`00Oomoo`3SOol002Uoo`03001oogoo05Mo
o`@000Aoo`03001oogoo0>=oo`00:Goo00<007ooOol0F7oo0P001Goo00<007ooOol0hgoo000YOol0
0`00Oomoo`1OOol00`00Oomoo`3SOol002Uoo`03001oogoo05ioo`800>Eoo`00:Goo00<007ooOol0
ogooAWoo000YOol00`00Oomoo`3oOom6Ool002Uoo`03001oogoo0?moodIoo`00:Goo00<007ooOol0
ogooAWoo000YOol00`00Oomoo`3oOom6Ool002Uoo`03001oogoo0?moodIoo`00:Goo00<007ooOol0
ogooAWoo000YOol00`00Oomoo`3oOom6Ool002Uoo`03001oogoo0?moodIoo`00:Goo00<007ooOol0
ogooAWoo000YOol00`00Oomoo`3oOom6Ool002Uoo`03001oogoo0?moodIoo`00:Goo00<007ooOol0
ogooAWoo000YOol00`00Oomoo`3oOom6Ool002Uoo`03001oogoo0?moodIoo`00:Goo00<007ooOol0
ogooAWoo000YOol00`00Oomoo`3oOom6Ool002Uoo`800?moodMoo`00:Goo00<007oo0000ogooAWoo
000YOol00`00Ool0003oOom6Ool002Uoo`04001oogoo003oOom5Ool002Uoo`05001oogooOol0003o
Oom4Ool002Uoo`03001oogoo009oo`03001oogoo0?mood5oo`00:Goo00<007ooOol00goo00<007oo
Ool0ogoo@7oo000YOol00`00Oomoo`03Ool00`00Oomoo`3oOom0Ool002Uoo`03001oogoo00Aoo`03
001oogoo0?moocmoo`00:Goo00<007ooOol01Goo00<007ooOol0ogoo?Woo000YOol00`00Oomoo`06
Ool00`00Oomoo`3oOolmOol002Uoo`03001oogoo00Moo`03001oogoo0?moocaoo`00:Goo00<007oo
Ool01goo00<007ooOol0ogoo?7oo000YOol00`00Oomoo`08Ool00`00Oomoo`3oOolkOol002Uoo`03
001oogoo00Uoo`03001oogoo0?moocYoo`00:Goo00<007ooOol02Woo00<007ooOol097oo1@0000=o
o`0000000`00EGoo0`000Woo1@00ZWoo000YOol00`00Oomoo`0;Ool00`00Oomoo`0SOol40004Ool0
0`00Oomoo`1DOol00`00Oomoo`05Ool00`00Oomoo`2ZOol002Uoo`03001oogoo00]oo`03001oogoo
02Ioo`03001oogoo009oo`03001oogoo05Aoo`03001oogoo00Eoo`03001oogoo0:Yoo`00:Goo00<0
07ooOol037oo00<007ooOol08goo0`0017oo00<007ooOol0EGoo0`0017oo00<007ooOol0ZWoo000Y
Ool00`00Oomoo`0=Ool00`00Oomoo`0YOol00`00Oomoo`1LOol00`00Oomoo`2ZOol002Uoo`03001o
ogoo00ioo`03001oogoo02Moo`8005eoo`800:aoo`00:Goo00<007ooOol03goo00<007ooOol0ogoo
=7oo000YOol00`00Oomoo`0?Ool00`00Oomoo`3oOoldOol002Uoo`03001oogoo011oo`03001oogoo
0?mooc=oo`00:Goo00<007ooOol04Goo00<007ooOol0ogoo<Woo000YOol00`00Oomoo`0BOol00`00
Oomoo`3oOolaOol002Uoo`03001oogoo01=oo`03001oogoo0?mooc1oo`00:Goo00<007ooOol04goo
00<007ooOol0ogoo<7oo000YOol00`00Oomoo`0DOol00`00Oomoo`3oOol_Ool002Uoo`03001oogoo
01Eoo`03001oogoo0?moobioo`00:Goo00<007ooOol05Woo00<007ooOol0ogoo;Goo000YOol00`00
Oomoo`0GOol00`00Oomoo`3oOol/Ool00?l00740005oo`00:Goo10005goo00<007ooOol08Goo00<0
07ooOol0?Goo00<007ooOol077oo00<007ooOol0Ygoo000YOol00`00Oomoo`04000EOol00`00Oomo
o`0POol00`00Oomoo`0mOol00`00Oomoo`0LOol00`00Oomoo`2WOol002Uoo`06001oogooOol007oo
0`0057oo00<007ooOol07goo00<007ooOol0?Goo00<007ooOol077oo00<007ooOol0Ygoo000YOol0
0`00Oomoo`02Ool20002Ool3000BOol00`00Oomoo`0NOol00`00Oomoo`0mOol00`00Oomoo`0LOol0
0`00Oomoo`2WOol002Uoo`03001oogoo00Aoo`04001oogooOol3000@Ool00`00Oomoo`0NOol00`00
Oomoo`0mOol00`00Oomoo`0LOol00`00Oomoo`2WOol002Uoo`03001oogoo00Eoo`03001oogoo009o
o`@000ioo`03001oogoo01eoo`03001oogoo03eoo`03001oogoo01aoo`03001oogoo0:Moo`00:Goo
00<007ooOol01Woo0P0017oo10003Goo00<007ooOol077oo00<007ooOol0?Goo00<007ooOol077oo
00<007ooOol0Ygoo000YOol00`00Oomoo`08Ool00`00Oomoo`03Ool5000;Ool00`00Oomoo`0KOol0
0`00Oomoo`0mOol00`00Oomoo`0LOol00`00Oomoo`2WOol002Uoo`03001oogoo00Uoo`8000Eoo`80
0003Ool0000000Yoo`03001oogoo01Yoo`03001oogoo03eoo`03001oogoo01aoo`03001oogoo0:Mo
o`00:Goo00<007ooOol02goo00<007ooOol017oo0P0000Aoo`00000000Moo`03001oogoo01Yoo`03
001oogoo03eoo`03001oogoo01aoo`03001oogoo0:Moo`00:Goo00<007ooOol037oo00<007ooOol0
1Goo0P000Woo0P001Woo00<007ooOol06Goo00<007ooOol0?Goo00<007ooOol077oo00<007ooOol0
Ygoo000YOol00`00Oomoo`0=Ool20007Ool20002Ool30004Ool00`00Oomoo`0HOol00`00Oomoo`0m
Ool00`00Oomoo`0LOol00`00Oomoo`2WOol002Uoo`03001oogoo00moo`03001oogoo00Ioo`03001o
ogoo009oo`8000=oo`03001oogoo01Moo`03001oogoo03eoo`03001oogoo01aoo`03001oogoo0:Mo
o`00:Goo00<007ooOol047oo00<007ooOol01Woo0P0017oo0`0000=oo`00Ool05goo00<007ooOol0
?Goo00<007ooOol077oo00<007ooOol0Ygoo000YOol00`00Oomoo`0AOol20008Ool00`00Oomoo`04
Ool2000HOol00`00Oomoo`0mOol00`00Oomoo`0LOol00`00Oomoo`2WOol002Uoo`03001oogoo01=o
o`03001oogoo00Ioo`8000Ioo`<001Eoo`03001oogoo03eoo`03001oogoo01aoo`03001oogoo0:Mo
o`00:Goo00<007ooOol057oo00<007ooOol01goo00<007ooOol017oo00@007oo000001=oo`03001o
ogoo03eoo`03001oogoo01aoo`03001oogoo0:Moo`00:Goo00<007ooOol05Goo0P0027oo00<007oo
Ool017oo00<007ooOol00`0047oo00<007ooOol0?Goo00<007ooOol077oo00<007ooOol0Ygoo000Y
Ool00`00Oomoo`0GOol00`00Oomoo`06Ool20005Ool00`00Oomoo`02Ool2000>Ool00`00Oomoo`0m
Ool00`00Oomoo`0LOol00`00Oomoo`2WOol002Uoo`03001oogoo01Qoo`8000Qoo`03001oogoo009o
o`03001oogoo00Aoo`<000]oo`03001oogoo03eoo`03001oogoo01aoo`03001oogoo0:Moo`00:Goo
00<007ooOol06Woo00<007ooOol01Woo0P000goo00<007ooOol01Woo0P002Goo00<007ooOol0?Goo
00<007ooOol077oo00<007ooOol0Ygoo000YOol00`00Oomoo`0KOol00`00Oomoo`07Ool01@00Oomo
ogoo00002Goo0`001Woo00<007ooOol0?Goo00<007ooOol077oo00<007ooOol0Ygoo000YOol00`00
Oomoo`0LOol20008Ool01@00Oomoogoo00002goo0P0017oo00<007ooOol0?Goo00<007ooOol077oo
00<007ooOol0Ygoo000YOol00`00Oomoo`0NOol00`00Oomoo`06Ool01@00Oomoogoo000037oo0`00
00=oo`00Ool0?Woo00<007ooOol077oo00<007ooOol0Ygoo000YOol00`00Oomoo`0OOol00`00Oomo
o`06Ool01000Oomoo`003goo0P00?goo00<007ooOol077oo00<007ooOol0Ygoo000YOol00`00Oomo
o`0POol20007Ool01000Oomoo`003goo1000?7oo00<007ooOol077oo00<007ooOol0Ygoo000YOol0
0`00Oomoo`0ROol00`00Oomoo`05Ool01000Oomoo`003Woo00@007ooOomoo`8003Yoo`03001oogoo
01aoo`03001oogoo0:Moo`00:Goo00<007ooOol08goo0P001Woo00@007ooOol000eoo`03001oogoo
00=oo`<003Moo`03001oogoo01aoo`03001oogoo0:Moo`00:Goo00<007ooOol09Goo00<007ooOol0
17oo00@007ooOol000aoo`03001oogoo00Ioo`8003Eoo`03001oogoo01aoo`03001oogoo0:Moo`00
:Goo00<007ooOol09Woo00<007ooOol017oo00<007oo000037oo00<007ooOol027oo0`00<Woo00<0
07ooOol077oo00<007ooOol0Ygoo000YOol00`00Oomoo`0WOol20005Ool00`00Ool0000;Ool00`00
Oomoo`0;Ool2000`Ool00`00Oomoo`0LOol00`00Oomoo`2WOol002Uoo`03001oogoo02Uoo`03001o
ogoo00=oo`03001oo`0000Yoo`03001oogoo00eoo`<002eoo`03001oogoo01aoo`03001oogoo0:Mo
o`00:Goo00<007ooOol0:Woo00<007ooOol00goo00<007oo00002Goo00<007ooOol047oo0P00:goo
00<007ooOol077oo00<007ooOol0Ygoo000YOol00`00Oomoo`0[Ool20004Ool00`00Ool00008Ool0
0`00Oomoo`0BOol3000XOol00`00Oomoo`0LOol00`00Oomoo`2WOol002Uoo`03001oogoo02eoo`03
001oogoo009oo`8000Qoo`03001oogoo01Eoo`8002Ioo`03001oogoo01aoo`03001oogoo0:Moo`00
:Goo00<007ooOol0;Woo00<007ooOol00Woo0P001goo00<007ooOol05goo0`008goo00<007ooOol0
77oo00<007ooOol0Ygoo000YOol00`00Oomoo`0_Ool20003Ool20006Ool00`00Oomoo`0JOol2000Q
Ool00`00Oomoo`0LOol00`00Oomoo`2WOol002Uoo`03001oogoo035oo`04001oogooOol20005Ool0
0`00Oomoo`0LOol3000NOol00`00Oomoo`0LOol00`00Oomoo`2WOol002Uoo`03001oogoo039oo`80
0004Ool007oo0004Ool00`00Oomoo`0OOol2000LOol00`00Oomoo`0LOol00`00Oomoo`2WOol002Uo
o`03001oogoo03Aoo`04001oo`000004Ool00`00Oomoo`0QOol3000IOol00`00Oomoo`0LOol00`00
Oomoo`2WOol002Uoo`03001oogoo03Eoo`04001oo`000003Ool00`00Oomoo`0TOol2000GOol00`00
Oomoo`0LOol00`00Oomoo`2WOol002Uoo`03001oogoo03Ioo`@0009oo`03001oogoo02Ioo`<001Ao
o`03001oogoo01aoo`03001oogoo0:Moo`00:Goo00<007ooOol0>7oo0`0000=oo`00Ool0:Woo0P00
4Woo00<007ooOol077oo00<007ooOol0Ygoo000YOol00`00Oomoo`0iOol4000]Ool3000?Ool00`00
Oomoo`0LOol00`00Oomoo`2WOol000=oo`@000=oo`D001Yoo`03001oogoo03Yoo`<0031oo`8000eo
o`03001oogoo01aoo`03001oogoo0:Moo`0017oo00@007ooOol000Aoo`03001oogoo01Yood00039o
o`<000Yoo`03001oogoo01aoo`03001oogoo0:Moo`0017oo00@007ooOol000Aoo`03001oogoo01Yo
o`03001oogoo03aoo`<003=oo`8000Qoo`03001oogoo01aoo`03001oogoo0:Moo`0017oo0`001Goo
00<007ooOol06Woo00<007ooOol0?Goo0`00=7oo0`001Goo00<007ooOol077oo00<007ooOol0Ygoo
0004Ool00`00Oomoo`05Ool00`00Oomoo`0JOol00`00Oomoo`0nOol00`00Ool0000fOol20003Ool0
0`00Oomoo`0LOol00`00Oomoo`2WOol000=oo`8000Ioo`8001aoo`03001oogoo03moo`04001oo`00
000fOol4000NOol00`00Oomoo`2WOol002Uoo`03001oogoo041oo`04001oogoo000hOol2000MOol0
0`00Oomoo`2WOol002Uoo`03001oogoo041oo`80009oo`03001oogoo03Eoo`03001oo`00008001Yo
o`03001oogoo0:Moo`00:Goo00<007ooOol0@Goo0P000Woo0P00=Goo00<007ooOol00Woo0P0067oo
00<007ooOol0Ygoo000YOol00`00Oomoo`12Ool00`00Oomoo`02Ool00`00Oomoo`0bOol00`00Oomo
o`04Ool3000EOol00`00Oomoo`2WOol002Uoo`03001oogoo04=oo`03001oogoo009oo`80039oo`03
001oogoo00Moo`8001=oo`03001oogoo0:Moo`00:Goo00<007ooOol0@goo0P001Goo00<007ooOol0
;goo00<007ooOol02Goo0`0047oo00<007ooOol0Ygoo000YOol00`00Oomoo`14Ool20005Ool00`00
Oomoo`0^Ool00`00Oomoo`0<Ool2000>Ool00`00Oomoo`2WOol002Uoo`03001oogoo04Eoo`8000Eo
o`8002ioo`03001oogoo00ioo`<000]oo`03001oogoo0:Moo`00:Goo00<007ooOol0AGoo0P001goo
00<007ooOol0:goo00<007ooOol04Goo0P002Goo00<007ooOol0Ygoo000YOol00`00Oomoo`16Ool2
0007Ool00`00Oomoo`0ZOol00`00Oomoo`0COol30006Ool00`00Oomoo`2WOol002Uoo`03001oogoo
04Moo`8000Moo`8002Yoo`03001oogoo01Ioo`8000Aoo`03001oogoo0:Moo`00:Goo00<007ooOol0
B7oo0P0027oo00<007ooOol09goo00<007ooOol067oo0`0000=oo`00Ool0Z7oo000YOol00`00Oomo
o`18Ool00`00Ool00008Ool2000WOol00`00Oomoo`0KOol2002YOol002Uoo`03001oogoo04Uoo`80
00Yoo`03001oogoo02Aoo`03001oogoo01aoo`<00:Moo`00:Goo00<007ooOol0BWoo0P002Woo00<0
07ooOol08goo00<007ooOol077oo00<007ooOol00`00Y7oo000YOol00`00Oomoo`1;Ool2000:Ool2
000SOol00`00Oomoo`0LOol00`00Oomoo`03Ool2002ROol002Uoo`03001oogoo04]oo`03001oo`00
00]oo`03001oogoo021oo`03001oogoo01aoo`03001oogoo00Eoo`<009moo`00:Goo00<007ooOol0
C7oo00<007oo00002goo00<007ooOol07goo00<007ooOol077oo00<007ooOol027oo0P00WGoo000Y
Ool00`00Oomoo`1=Ool2000<Ool2000OOol00`00Oomoo`0LOol00`00Oomoo`0:Ool3002JOol002Uo
o`03001oogoo04eoo`03001oo`0000eoo`03001oogoo01aoo`03001oogoo01aoo`03001oogoo00eo
o`8009Qoo`00:Goo00<007ooOol0CWoo00<007oo00003Goo0P0077oo00<007ooOol077oo00<007oo
Ool03goo0`00UGoo000YOol00`00Oomoo`1?Ool00`00Ool0000>Ool00`00Oomoo`0IOol00`00Oomo
o`0LOol00`00Oomoo`0BOol2002COol002Uoo`03001oogoo04moo`04001oogoo000>Ool00`00Oomo
o`0HOol00`00Oomoo`0LOol00`00Oomoo`0DOol3002@Ool002Uoo`03001oogoo051oo`03001oo`00
00moo`8001Qoo`03001oogoo01aoo`03001oogoo01Moo`8008ioo`00:Goo00<007ooOol0DGoo00<0
07oo000047oo00<007ooOol05Goo00<007ooOol077oo00<007ooOol06Goo0`0077oo1@000goo0`00
I7oo000YOol00`00Oomoo`1AOol01000Oomoo`0047oo00<007ooOol057oo00<007ooOol077oo00<0
07ooOol077oo0P006Woo10001Goo00<007ooOol0Hgoo000YOol00`00Oomoo`1BOol01000Oomoo`00
47oo0P0057oo00<007ooOol077oo00<007ooOol07Woo0`006Woo00<007ooOol01@00I7oo000YOol0
0`00Oomoo`1COol01000Oomoo`004Goo00<007ooOol04Goo00<007ooOol077oo00<007ooOol08Goo
0P005Woo0`000Woo00@007ooOol006Eoo`00:Goo00<007ooOol0Dgoo00@007ooOol0019oo`80015o
o`03001oogoo01aoo`03001oogoo02=oo`<001Uoo`03001oo`0006Eoo`00:Goo00<007ooOol0E7oo
00@007ooOol001=oo`03001oogoo00ioo`03001oogoo01aoo`03001oogoo02Ioo`8001Qoo`8006Eo
o`00:Goo00<007ooOol0EGoo00@007ooOol001=oo`03001oogoo00eoo`03001oogoo01aoo`03001o
ogoo02Qoo`<007aoo`00:Goo00<007ooOol0EGoo00D007ooOomoo`0001=oo`8000eoo`03001oogoo
01aoo`03001oogoo02]oo`8007Yoo`00:Goo00<007ooOol0EWoo00D007ooOomoo`0001Aoo`03001o
ogoo00Yoo`03001oogoo01aoo`03001oogoo02eoo`<007Moo`00:Goo00<007ooOol0Egoo00@007oo
Ool001Eoo`03001oogoo00Uoo`03001oogoo01aoo`03001oogoo031oo`8007Eoo`00:Goo00<007oo
Ool0Egoo00D007ooOomoo`0001Eoo`8000Uoo`03001oogoo01aoo`03001oogoo039oo`<0079oo`00
:Goo00<007ooOol0F7oo00D007ooOomoo`0001Ioo`03001oogoo00Ioo`03001oogoo01aoo`03001o
ogoo03Eoo`80071oo`00:Goo00<007ooOol0FGoo00D007ooOomoo`0001Ioo`8000Ioo`03001oogoo
01aoo`03001oogoo03Moo`<006eoo`00:Goo00<007ooOol0FGoo00<007ooOol00Woo00<007ooOol0
5Goo00<007ooOol00goo00<007ooOol077oo00<007ooOol0>Woo0P00Jgoo000YOol00`00Oomoo`1J
Ool01@00Oomoogoo000067oo00<007ooOol00Woo00<007ooOol077oo00<007ooOol0?7oo0`00J7oo
000YOol00`00Oomoo`1KOol01@00Oomoogoo000067oo0P000Woo00<007ooOol077oo00<007ooOol0
?goo0P00IWoo000YOol00`00Oomoo`1KOol00`00Oomoo`02Ool00`00Oomoo`0GOol00`00Ool0000N
Ool00`00Oomoo`11Ool3001SOol002Uoo`03001oogoo05aoo`03001oogoo009oo`03001oogoo01Mo
o`8001ioo`03001oogoo04Aoo`80065oo`00:Goo00<007ooOol0G7oo00<007ooOol00goo00<007oo
Ool05goo0P007Goo00<007ooOol0AWoo0`00GWoo000YOol00`00Oomoo`1MOol00`00Oomoo`02Ool0
0`00Oomoo`0GOol00`00Ool0000LOol00`00Oomoo`19Ool2001LOol002Uoo`03001oogoo05ioo`03
001oogoo009oo`03001oogoo01Ioo`03001oogoo008001Yoo`03001oogoo04]oo`<005Uoo`00:Goo
00<007ooOol0GWoo00<007ooOol00goo00<007ooOol05Goo00<007ooOol00Woo00<007ooOol05goo
00<007ooOol0CWoo0P00Egoo000YOol00`00Oomoo`1OOol00`00Oomoo`03Ool00`00Oomoo`0DOol0
0`00Oomoo`03Ool00`00Oomoo`0FOol00`00Oomoo`1@Ool3001DOol002Uoo`03001oogoo05moo`03
001oogoo00Aoo`03001oogoo01=oo`03001oogoo00Aoo`8001Ioo`03001oogoo05=oo`80059oo`00
:Goo00<007ooOol0H7oo00<007ooOol00goo00<007ooOol04goo00<007ooOol01Woo00<007ooOol0
4goo00<007ooOol0EGoo0`00Cgoo000YOol00`00Oomoo`1POol00`00Oomoo`04Ool00`00Oomoo`0B
Ool00`00Oomoo`07Ool2000COol00`00Oomoo`1HOol2001=Ool002Uoo`03001oogoo065oo`03001o
ogoo00Aoo`03001oogoo015oo`03001oogoo00Uoo`03001oogoo011oo`03001oogoo05Yoo`<004Yo
o`00:Goo00<007ooOol0HWoo00<007ooOol017oo00<007ooOol047oo00<007ooOol02Woo00<007oo
Ool03goo00<007ooOol0GGoo0P00B7oo000YOol00`00Oomoo`1ROol00`00Oomoo`05Ool00`00Oomo
o`0?Ool00`00Oomoo`0;Ool2000?Ool00`00Oomoo`1OOol30015Ool002Uoo`03001oogoo06=oo`03
001oogoo00Aoo`03001oogoo00moo`03001oogoo00eoo`03001oogoo00aoo`03001oogoo069oo`80
04=oo`00:Goo00<007ooOol0Hgoo00<007ooOol01Goo00<007ooOol03Woo00<007ooOol03Woo00<0
07ooOol02goo00<007ooOol0I7oo0`00@7oo000YOol00`00Oomoo`1TOol00`00Oomoo`05Ool00`00
Oomoo`0=Ool00`00Oomoo`0?Ool2000;Ool00`00Oomoo`1WOol2000nOol002Uoo`03001oogoo06Eo
o`03001oogoo00Eoo`03001oogoo00aoo`03001oogoo015oo`03001oogoo00Qoo`03001oogoo06Uo
o`<003]oo`00:Goo00<007ooOol0IGoo00<007ooOol01Woo00<007ooOol02goo00<007ooOol04Woo
0P0027oo00<007ooOol0K7oo0P00>Goo000YOol00`00Oomoo`1VOol00`00Oomoo`05Ool00`00Oomo
o`0;Ool00`00Oomoo`0DOol00`00Oomoo`05Ool00`00Oomoo`1^Ool3000fOol002Uoo`03001oogoo
06Ioo`03001oogoo00Ioo`03001oogoo00Yoo`03001oogoo01Eoo`03001oogoo00Aoo`03001oogoo
075oo`8003Aoo`00:Goo00<007ooOol0Igoo00<007ooOol01Woo00<007ooOol02Goo00<007ooOol0
5Woo0P0017oo00<007ooOol0Lgoo0`00<Goo000YOol00`00Oomoo`1XOol00`00Oomoo`06Ool00`00
Oomoo`08Ool00`00Oomoo`0HOol01@00Oomoogoo0000N7oo0P00;goo000YOol00`00Oomoo`1XOol0
0`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`0IOol01000Oomoo`00NWoo0`00;7oo000YOol0
0`00Oomoo`1YOol00`00Oomoo`06Ool00`00Oomoo`07Ool00`00Oomoo`0JOol3001mOol2000ZOol0
02Uoo`03001oogoo06Yoo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo01aoo`03001oogoo
07eoo`<002Moo`00:Goo00<007ooOol0JWoo00<007ooOol01goo00<007ooOol01Goo00<007ooOol0
77oo0`00P7oo0P009Goo000YOol00`00Oomoo`1[Ool00`00Oomoo`07Ool00`00Oomoo`04Ool00`00
Oomoo`0LOol01000Oomoo`00PGoo0`008Woo000YOol00`00Oomoo`1/Ool00`00Oomoo`07Ool00`00
Oomoo`03Ool00`00Oomoo`0LOol01@00Oomoogoo0000Pgoo0P0087oo000YOol00`00Oomoo`1/Ool0
0`00Oomoo`07Ool00`00Oomoo`03Ool00`00Oomoo`0LOol00`00Oomoo`02Ool20023Ool3000MOol0
02Uoo`03001oogoo06eoo`03001oogoo00Moo`03001oogoo009oo`03001oogoo01aoo`03001oogoo
00Aoo`03001oogoo08=oo`8001]oo`00:Goo00<007ooOol0KWoo00<007ooOol01goo00D007ooOomo
o`0001ioo`03001oogoo00Eoo`03001oogoo08Aoo`<001Qoo`00:Goo00<007ooOol0Kgoo00<007oo
Ool01goo00@007ooOol001ioo`03001oogoo00Ioo`8008Moo`8001Ioo`00:Goo00<007ooOol0Kgoo
00<007ooOol027oo00<007oo00007Woo00<007ooOol027oo00<007ooOol0QWoo0`004goo000YOol0
0`00Oomoo`1`Ool00`00Oomoo`07Ool00`00Ool0000NOol00`00Oomoo`09Ool20029Ool2000AOol0
02Uoo`03001oogoo075oo`03001oogoo00Moo`8001ioo`03001oogoo00]oo`03001oogoo00Yoo`D0
0004Ool00000001eOol3000>Ool002Uoo`03001oogoo075oo`03001oogoo00Qoo`03001oogoo01ao
o`03001oogoo00aoo`03001oogoo00Uoo`@0009oo`04001oogoo001gOol2000<Ool002Uoo`03001o
ogoo079oo`03001oogoo00Moo`8001eoo`03001oogoo00eoo`8000aoo`04001oogoo0002Ool00`00
Oomoo`1gOol2000:Ool002Uoo`03001oogoo07=oo`03001oogoo00Ioo`03001oo`0001aoo`03001o
ogoo00moo`03001oogoo00Moo`<0009oo`<008Ioo`00:Goo00<007ooOol0Lgoo00<007ooOol01Woo
00<007oo000077oo00<007ooOol047oo00<007ooOol037oo00<007ooOol0QGoo000YOol00`00Oomo
o`1dOol00`00Oomoo`05Ool01000Oomoo`006goo00<007ooOol04Goo0P0037oo0`00QGoo000YOol0
0`00Oomoo`1eOol00`00Oomoo`04Ool01@00Oomoogoo00006Woo00<007ooOol04goo00<007ooOol0
TGoo000YOol00`00Oomoo`1eOol00`00Oomoo`04Ool00`00Oomoo`02Ool00`00Oomoo`0GOol00`00
Oomoo`0DOol2002AOol002Uoo`03001oogoo07Ioo`03001oogoo00=oo`03001oogoo00=oo`03001o
ogoo01Ioo`03001oogoo01Ioo`03001oogoo08ioo`00:Goo00<007ooOol0Mgoo00<007ooOol00Woo
00<007ooOol00goo00<007ooOol05Woo00<007ooOol05goo00<007ooOol0SGoo000YOol00`00Oomo
o`1gOol00`00Oomoo`02Ool00`00Oomoo`04Ool00`00Oomoo`0EOol00`00Oomoo`0HOol2002=Ool0
02Uoo`03001oogoo07Qoo`05001oogooOol00007Ool00`00Oomoo`0DOol00`00Oomoo`0JOol00`00
Oomoo`2:Ool002Uoo`03001oogoo07Uoo`04001oogoo0008Ool00`00Oomoo`0COol00`00Oomoo`0K
Ool00`00Oomoo`29Ool002Uoo`03001oogoo07Yoo`03001oo`0000Uoo`03001oogoo019oo`03001o
ogoo01aoo`8008Uoo`00:Goo00<007ooOol0NWoo00<007oo00002Goo00<007ooOol04Woo00<007oo
Ool07Woo00<007ooOol0QWoo000YOol00`00Oomoo`1kOol2000:Ool00`00Oomoo`0AOol00`00Oomo
o`0OOol20026Ool002Uoo`03001oogoo07aoo`03001oogoo00Uoo`03001oogoo011oo`03001oogoo
025oo`03001oogoo08=oo`00:GooP00037oo00<007ooOol03goo00<007ooOol08Woo00<007ooOol0
PWoo000YOol00`00Oomoo`1mOol00`00Oomoo`0:Ool00`00Oomoo`0>Ool00`00Oomoo`0SOol20022
Ool002Uoo`03001oogoo07ioo`03001oogoo00Uoo`03001oogoo00ioo`03001oogoo02Eoo`03001o
ogoo07moo`00:Goo00<007ooOol0OWoo00<007ooOol02Woo00<007ooOol03Goo00<007ooOol09Woo
00<007ooOol0OWoo000YOol00`00Oomoo`1oOol00`00Oomoo`0:Ool00`00Oomoo`0<Ool00`00Oomo
o`0WOol2001nOol002Uoo`03001oogoo081oo`03001oogoo00Yoo`03001oogoo00]oo`03001oogoo
02Uoo`03001oogoo07]oo`00:Goo00<007ooOol0PGoo00<007ooOol02Woo00<007ooOol02Woo00<0
07ooOol0:Woo0P00Ngoo000YOol00`00Oomoo`21Ool00`00Oomoo`0:Ool00`00Oomoo`0:Ool00`00
Oomoo`0/Ool00`00Oomoo`1hOol002Uoo`03001oogoo089oo`03001oogoo00Yoo`03001oogoo00Uo
o`03001oogoo02eoo`03001oogoo07Moo`00:Goo00<007ooOol0Pgoo00<007ooOol02Woo00<007oo
Ool027oo00<007ooOol0;Woo0P00Mgoo000YOol00`00Oomoo`24Ool00`00Oomoo`0:Ool00`00Oomo
o`07Ool00`00Oomoo`0`Ool00`00Oomoo`1dOol002Uoo`03001oogoo08Eoo`03001oogoo00Yoo`03
001oogoo00Ioo`03001oogoo035oo`03001oogoo07=oo`00:Goo00<007ooOol0QGoo00<007ooOol0
2Woo00<007ooOol01Woo00<007ooOol0<Woo0P00Lgoo000YOol00`00Oomoo`26Ool00`00Oomoo`0:
Ool00`00Oomoo`05Ool00`00Oomoo`0dOol00`00Oomoo`1`Ool002Uoo`03001oogoo08Moo`03001o
ogoo00Yoo`03001oogoo00Aoo`03001oogoo03Eoo`80071oo`00:Goo00<007ooOol0R7oo00<007oo
Ool02Woo00<007ooOol00goo00<007ooOol0=goo00<007ooOol0KGoo000YOol00`00Oomoo`29Ool0
0`00Oomoo`0:Ool00`00Oomoo`02Ool00`00Oomoo`0hOol00`00Oomoo`1/Ool002Uoo`03001oogoo
08Yoo`03001oogoo00Uoo`03001oogoo009oo`03001oogoo03Uoo`8006aoo`00:Goo00<007ooOol0
Rgoo00<007ooOol02Goo00D007ooOomoo`0003eoo`03001oogoo06Uoo`00:Goo00<007ooOol0S7oo
00<007ooOol02Goo00@007ooOol003ioo`03001oogoo06Qoo`00:Goo00<007ooOol0S7oo00<007oo
Ool02Woo00<007oo0000?goo0P00J7oo000YOol00`00Oomoo`2=Ool00`00Oomoo`0:Ool20011Ool0
0`00Oomoo`1UOol002Uoo`03001oogoo08ioo`03001oogoo00Uoo`80049oo`8006Eoo`00:Goo00<0
07ooOol0Sgoo00<007ooOol02Goo00<007ooOol0@Woo00<007ooOol0HWoo000YOol00`00Oomoo`2@
Ool00`00Oomoo`08Ool20014Ool00`00Oomoo`1QOol002Uoo`03001oogoo095oo`03001oogoo00Mo
o`03001oo`0004Aoo`80065oo`00:Goo00<007ooOol0TWoo00<007ooOol01Woo00@007ooOol004Eo
o`03001oogoo05ioo`00:Goo00<007ooOol0Tgoo00<007ooOol01Goo00@007ooOol004Ioo`8005io
o`00:Goo00<007ooOol0U7oo00<007ooOol017oo00D007ooOomoo`0004Moo`03001oogoo05]oo`00
:Goo00<007ooOol0UGoo00<007ooOol00goo00<007ooOol00Woo00<007ooOol0AGoo00<007ooOol0
FWoo000YOol00`00Oomoo`2FOol00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`15Ool2001J
Ool002Uoo`03001oogoo09Moo`05001oogooOol00006Ool00`00Oomoo`16Ool00`00Oomoo`1GOol0
02Uoo`03001oogoo09Qoo`04001oogoo0006Ool00`00Oomoo`17Ool00`00Oomoo`1FOol002Uoo`03
001oogoo09Uoo`03001oo`0000Moo`03001oogoo04Moo`8005Ioo`0027oo100000=oo`0000000`00
5goo00<007ooOol0VWoo0P0027oo00<007ooOol0B7oo00<007ooOol0Dgoo0007Ool01000Oomoo`00
17oo00<007ooOol05gooW`002Goo00<007ooOol0B7oo0P00Dgoo0007Ool01000Oomoo`0017oo00<0
07ooOol05goo00<007ooOol0W7oo0P0027oo00<007ooOol0BGoo00<007ooOol0D7oo0008Ool30004
Ool00`00Oomoo`0GOol00`00Oomoo`2NOol00`00Oomoo`05Ool00`00Oomoo`1:Ool00`00Oomoo`1?
Ool000Yoo`03001oogoo009oo`03001oogoo01Moo`03001oogoo09moo`03001oogoo00Eoo`03001o
ogoo04Yoo`8004moo`002Goo0P000goo0P006Goo00<007ooOol0X7oo0P001Woo00<007ooOol0Bgoo
00<007ooOol0C7oo000YOol00`00Oomoo`2ROol00`00Oomoo`04Ool00`00Oomoo`1;Ool00`00Oomo
o`1;Ool002Uoo`03001oogoo0:=oo`8000Eoo`03001oogoo04]oo`8004]oo`00:Goo00<007ooOol0
YGoo00<007ooOol00Woo00<007ooOol0CGoo00<007ooOol0B7oo000YOol00`00Oomoo`2VOol00`00
Oomoo`02Ool00`00Oomoo`1=Ool20018Ool002Uoo`03001oogoo0:Moo`8000=oo`03001oogoo04io
o`03001oogoo04Eoo`00:Goo00<007ooOol0ZGoo00D007ooOomoo`00051oo`03001oogoo04Aoo`00
:Goo00<007ooOol0ZWoo0P000Woo00<007ooOol0CWoo0P00A7oo000YOol00`00Oomoo`2/Ool3001B
Ool00`00Oomoo`11Ool002Uoo`03001oogoo0:ioo`80059oo`03001oogoo041oo`00:Goo00<007oo
Ool0/7oo0P00DGoo0P00@7oo000YOol00`00Oomoo`2aOol3001AOol00`00Oomoo`0mOol002Uoo`03
001oogoo0;9oo`04001oo`00000POol500000goo00000002000VOol2000mOol002Uoo`03001oogoo
0;9oo`04001oogooOol2000NOol40002Ool00`00Oomoo`0YOol00`00Oomoo`0jOol002Uoo`03001o
ogoo0;=oo`03001oogoo009oo`8001moo`05001oogooOol0000[Ool00`00Oomoo`0iOol002Uoo`03
001oogoo0;Aoo`03001oogoo00=oo`<001Yoo`<000Aoo`03001oogoo02Uoo`8003Uoo`00:Goo00<0
07ooOol0]Goo00<007ooOol01Goo0`0077oo00@007ooOol002aoo`03001oogoo03Ioo`00:Goo00<0
07ooOol0]Woo00<007ooOol01goo0P006goo0P00;Woo00<007ooOol0=Goo000YOol00`00Oomoo`2f
Ool00`00Oomoo`09Ool30019Ool2000eOol002Uoo`03001oogoo0;Moo`03001oogoo00]oo`8004Uo
o`03001oogoo039oo`00:Goo00<007ooOol0^7oo00<007ooOol037oo0P00B7oo0P00<Woo000YOol0
0`00Oomoo`2iOol00`00Oomoo`0=Ool30017Ool00`00Oomoo`0_Ool002Uoo`03001oogoo0;Yoo`03
001oogoo00moo`8004Ioo`03001oogoo02ioo`00:Goo00<007ooOol0^Woo00<007ooOol04Goo0P00
AGoo0P00;Woo000YOol00`00Oomoo`2kOol00`00Oomoo`0BOol30014Ool00`00Oomoo`0[Ool002Uo
o`03001oogoo0;aoo`03001oogoo01Aoo`8004=oo`03001oogoo02Yoo`00:Goo00<007ooOol0_Goo
00<007ooOol05Goo0P00@Woo0P00:Woo000YOol00`00Oomoo`2mOol00`00Oomoo`0GOol20012Ool0
0`00Oomoo`0WOol002Uoo`03001oogoo0;ioo`03001oogoo01Qoo`8006Yoo`00:Goo00<007ooOol0
_goo00<007ooOol06Goo0P00J7oo000YOol00`00Oomoo`30Ool00`00Oomoo`0JOol00`00Oomoo`1U
Ool002Uoo`03001oogoo0<5oo`03001oogoo01Yoo`8006Eoo`00:Goo00<007ooOol0`Goo00<007oo
Ool077oo00<007ooOol0HWoo000YOol00`00Oomoo`32Ool00`00Oomoo`0LOol00`00Oomoo`1QOol0
02Uoo`03001oogoo0<=oo`03001oogoo01aoo`80065oo`00:Goo00<007ooOol0a7oo00<007ooOol0
7Goo00<007ooOol0GWoo000YOol00`00Oomoo`35Ool00`00Oomoo`0MOol2001NOol002Uoo`03001o
ogoo0<Eoo`03001oogoo01moo`03001oogoo05]oo`00:Goo00<007ooOol0aWoo00<007ooOol07goo
00<007ooOol0FWoo000YOol00`00Oomoo`37Ool00`00Oomoo`0OOol2001JOol002Uoo`03001oogoo
0<Qoo`03001oogoo021oo`03001oogoo05Moo`00:Goo00<007ooOol0bGoo00<007ooOol087oo00<0
07ooOol0EWoo000YOol00`00Oomoo`39Ool00`00Oomoo`0QOol00`00Oomoo`1EOol002Uoo`03001o
ogoo0<Yoo`03001oogoo025oo`03001oogoo05Aoo`00:Goo00<007ooOol0bgoo00<007ooOol08Goo
00<007ooOol0Dgoo000YOol00`00Oomoo`3<Ool00`00Oomoo`0QOol00`00Oomoo`1BOol002Uoo`03
001oogoo0<eoo`03001oogoo025oo`80059oo`00:Goo00<007ooOol0cGoo00<007ooOol08goo00<0
07ooOol0Cgoo000YOol00`00Oomoo`3>Ool00`00Oomoo`0SOol00`00Oomoo`1>Ool002Uoo`03001o
ogoo0<moo`03001oogoo02=oo`03001oogoo04eoo`00:Goo00<007ooOol0d7oo00<007ooOol08goo
00<007ooOol0C7oo000YOol00`00Oomoo`3AOol00`00Oomoo`0SOol00`00Oomoo`1;Ool002Uoo`03
001oogoo0=5oo`03001oogoo02Aoo`03001oogoo04Yoo`00:Goo00<007ooOol0dWoo00<007ooOol0
97oo00<007ooOol0BGoo000YOol00`00Oomoo`3COol00`00Oomoo`0TOol00`00Oomoo`18Ool002Uo
o`03001oogoo0=Aoo`03001oogoo02Aoo`03001oogoo04Moo`00:Goo00<007ooOol0eGoo00<007oo
Ool097oo00<007ooOol0AWoo000YOol00`00Oomoo`3EOol00`00Oomoo`0TOol00`00Oomoo`16Ool0
02Uoo`03001oogoo0=Ioo`03001oogoo02Aoo`03001oogoo04Eoo`00:Goo00<007ooOol0egoo00<0
07ooOol097oo00<007ooOol0A7oo000YOol00`00Oomoo`3HOol00`00Oomoo`0TOol00`00Oomoo`13
Ool002Uoo`03001oogoo0=Uoo`03001oogoo02Aoo`03001oogoo049oo`00:Goo00<007ooOol0fGoo
00<007ooOol09Goo00<007ooOol0@Goo000YOol00`00Oomoo`3JOol00`00Oomoo`0UOol00`00Oomo
o`10Ool002Uoo`03001oogoo0=]oo`03001oogoo02Eoo`03001oogoo03moo`00:Goo00<007ooOol0
g7oo00<007ooOol097oo00<007ooOol0?goo000YOol00`00Oomoo`3MOol00`00Oomoo`0TOol00`00
Oomoo`0nOol002Uoo`03001oogoo0=eoo`03001oogoo02Eoo`03001oogoo03eoo`00:Goo00<007oo
Ool0gWoo00<007ooOol09Goo00<007ooOol0?7oo000YOol00`00Oomoo`3OOol00`00Oomoo`0UOol0
0`00Oomoo`0kOol002Uoo`03001oogoo0>1oo`03001oogoo02Aoo`03001oogoo03]oo`00:Goo00<0
07ooOol0hGoo00<007ooOol097oo00<007ooOol0>Woo000YOol00`00Oomoo`3QOol00`00Oomoo`0U
Ool00`00Oomoo`0iOol002Uoo`03001oogoo0>9oo`03001oogoo02Eoo`03001oogoo03Qoo`00:Goo
00<007ooOol0hgoo00<007ooOol097oo00<007ooOol0>7oo000YOol00`00Oomoo`0GOol50002Ool2
0034Ool00`00Oomoo`0TOol00`00Oomoo`0gOol002Uoo`03001oogoo01Moo`@0009oo`04001oogoo
0034Ool00`00Oomoo`0TOol00`00Oomoo`0fOol002Uoo`03001oogoo01Yoo`03001oogoo00=oo`03
001oogoo0<9oo`03001oogoo02Aoo`03001oogoo03Ioo`00:Goo00<007ooOol067oo0`000goo0P00
aWoo00<007ooOol097oo00<007ooOol0=Goo000YOol00`00Oomoo`0NOol00`00Oomoo`36Ool00`00
Oomoo`0TOol00`00Oomoo`0dOol002Uoo`03001oogoo01ioo`<00<Moo`03001oogoo02Aoo`03001o
ogoo03=oo`00:Goo00<007ooOol0jGoo00<007ooOol08goo00<007ooOol0<goo000YOol00`00Oomo
o`3YOol00`00Oomoo`0TOol00`00Oomoo`0bOol002Uoo`03001oogoo0>Yoo`03001oogoo02Aoo`03
001oogoo035oo`00:Goo00<007ooOol0jgoo00<007ooOol097oo00<007ooOol0<7oo000YOol00`00
Oomoo`3/Ool00`00Oomoo`0SOol00`00Oomoo`0`Ool002Uoo`03001oogoo0>eoo`03001oogoo02=o
o`03001oogoo02moo`00:Goo00<007ooOol0kGoo00<007ooOol097oo00<007ooOol0;Woo000YOol0
0`00Oomoo`3^Ool00`00Oomoo`0SOol00`00Oomoo`0^Ool002Uoo`03001oogoo0>moo`03001oogoo
02=oo`03001oogoo02eoo`00:Goo00<007ooOol0l7oo00<007ooOol08goo00<007ooOol0;7oo000Y
Ool00`00Oomoo`3aOol00`00Oomoo`0ROol00`00Oomoo`0/Ool002Uoo`03001oogoo0?5oo`03001o
ogoo02=oo`03001oogoo02]oo`00:Goo00<007ooOol0lWoo00<007ooOol08goo00<007ooOol0:Woo
000YOol00`00Oomoo`3cOol00`00Oomoo`0ROol00`00Oomoo`0ZOol002Uoo`03001oogoo0?Aoo`03
001oogoo029oo`03001oogoo02Uoo`00:Goo00<007ooOol0mGoo00<007ooOol08Goo00<007ooOol0
:Goo000YOol00`00Oomoo`3eOol00`00Oomoo`0ROol00`00Oomoo`0XOol002Uoo`03001oogoo0?Io
o`03001oogoo029oo`03001oogoo02Moo`00:Goo00<007ooOol0mgoo00<007ooOol08Goo00<007oo
Ool09goo000YOol00`00Oomoo`3hOol00`00Oomoo`0QOol00`00Oomoo`0VOol002Uoo`03001oogoo
0?Uoo`03001oogoo025oo`03001oogoo02Eoo`00:Goo00<007ooOol0nGoo00<007ooOol08Goo00<0
07ooOol09Goo000YOol00`00Oomoo`3jOol00`00Oomoo`0QOol00`00Oomoo`0TOol002Uoo`03001o
ogoo0?]oo`03001oogoo025oo`03001oogoo02=oo`00:Goo00<007ooOol0ogoo87oo00<007ooOol0
8goo000YOol00`00Oomoo`3oOolQOol00`00Oomoo`0ROol002Uoo`03001oogoo0?moob9oo`03001o
ogoo025oo`00:Goo00<007ooOol0ogoo8Woo00<007ooOol08Goo000YOol00`00Oomoo`3oOolSOol0
0`00Oomoo`0POol002Uoo`03001oogoo0?moobAoo`03001oogoo01moo`00:Goo00<007ooOol0ogoo
97oo00<007ooOol07goo000YOol00`00Oomoo`3oOolUOol00`00Oomoo`0NOol002Uoo`03001oogoo
0?moobEoo`03001oogoo01ioo`00:Goo00<007ooOol0ogoo9Woo00<007ooOol07Goo000YOol00`00
Oomoo`3oOolWOol00`00Oomoo`0LOol002Uoo`03001oogoo0?moobMoo`03001oogoo01aoo`00:Goo
00<007ooOol0ogoo:7oo00<007ooOol06goo000YOol00`00Oomoo`3oOolYOol00`00Oomoo`0JOol0
02Uoo`03001oogoo0?moobUoo`03001oogoo01Yoo`00:Goo00<007ooOol0ogoo:Woo00<007ooOol0
6Goo000YOol00`00Oomoo`3oOol[Ool00`00Oomoo`0HOol002Uoo`03001oogoo0?moob]oo`03001o
ogoo01Qoo`00:Goo00<007ooOol0ogoo;7oo00<007ooOol05goo000YOol00`00Oomoo`3oOol/Ool0
0`00Oomoo`0GOol002Uoo`03001oogoo0?moobeoo`03001oogoo01Ioo`00:Goo00<007ooOol0ogoo
;Woo00<007ooOol05Goo000YOol00`00Oomoo`3oOol^Ool00`00Oomoo`0EOol002Uoo`03001oogoo
0?moobmoo`03001oogoo01Aoo`00:Goo00<007ooOol0ogoo<7oo00<007ooOol04goo000YOol00`00
Oomoo`3oOol`Ool00`00Oomoo`0COol002Uoo`03001oogoo0?mooc5oo`03001oogoo019oo`00:Goo
00<007ooOol0ogoo<Woo00<007ooOol04Goo000YOol00`00Oomoo`3oOolbOol00`00Oomoo`0AOol0
02Uoo`03001oogoo0?mooc=oo`03001oogoo011oo`00:Goo00<007ooOol0ogoo<goo00<007ooOol0
47oo000YOol00`00Oomoo`3oOoldOol00`00Oomoo`0?Ool002Uoo`03001oogoo0?moocEoo`03001o
ogoo00ioo`00:Goo00<007ooOol0ogoo=Goo00<007ooOol03Woo000YOol00`00Oomoo`3oOolfOol0
0`00Oomoo`0=Ool002Uoo`03001oogoo0?moocMoo`03001oogoo00aoo`00:Goo00<007ooOol0ogoo
=goo00<007ooOol037oo000YOol00`00Oomoo`3oOolhOol00`00Oomoo`0;Ool002Uoo`03001oogoo
0?moocQoo`03001oogoo00]oo`00:Goo00<007ooOol0ogoo>Goo00<007ooOol02Woo000YOol00`00
Oomoo`3oOoljOol00`00Oomoo`09Ool002Uoo`03001oogoo0?moocYoo`03001oogoo00Uoo`00:Goo
00<007ooOol0ogoo>goo00<007ooOol027oo000YOol00`00Oomoo`3oOom6Ool002Uoo`03001oogoo
0?moodIoo`00:Goo00<007ooOol0ogooAWoo000YOol00`00Oomoo`3oOom6Ool002Uoo`03001oogoo
0?moodIoo`00:Goo00<007ooOol0ogooAWoo000YOol00`00Oomoo`3oOom6Ool002Uoo`03001oogoo
0?moodIoo`00:Goo00<007ooOol0ogooAWoo000YOol00`00Oomoo`3oOom6Ool00001\
\>"],
  ImageRangeCache->{{{0, 368.188}, {402.625, 0}} -> {-1.29239, -2.02095, \
0.0314643, 0.0314643}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Display["\<Hopital2.eps\>", %, "\<EPS\>"]\)], "Input"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 680}},
WindowSize->{1016, 648},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 56, 1, 30, "Input"],
Cell[1798, 54, 50, 1, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[1885, 60, 278, 6, 50, "Input"],
Cell[2166, 68, 13778, 233, 332, 1105, 72, "GraphicsData", "PostScript", \
"Graphics"],
Cell[15947, 303, 130, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16114, 311, 647, 11, 90, "Input"],
Cell[16764, 324, 770, 12, 86, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[17571, 341, 53, 1, 30, "Input"],
Cell[17627, 344, 35009, 708, 412, 6827, 356, "GraphicsData", "PostScript", \
"Graphics"],
Cell[52639, 1054, 130, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[52806, 1062, 74, 1, 30, "Input"],
Cell[52883, 1065, 130, 3, 29, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

